using log4net;
using Microsoft.Azure.WebJobs;
using System;
using System.Threading.Tasks;
using VA.PPMS.IWS.ValidationDataService.Interface;

namespace VA.PPMS.IWS.Functions
{
    public static class ValidationDataTimerTrigger
    {
        [FunctionName("ValidationDataTimerTrigger")]
        public static async Task Run([TimerTrigger("0 0 3 * * 0")]TimerInfo validationDataTimer, 
            [Inject]IValidationDataService validationDataService,
            [Inject]ILog logger)
        {
            try
            {
                await validationDataService.ProcessData();
            }
            catch (Exception ex)
            {
                logger.Error($"There was a problem with ValidationDataTimerTrigger Processing.", ex);
            }
        }
    }
}